REBOL [
    subject: "Enregistrement/modification d'une catgorie"
    author: "Olivier Auverlot"
]

print "Content-type: text/html^/"
print {
    <HTML>
    </HEAD>
        <TITLE>Modification de la base</TITLE>
    </HEAD>
    <BODY>
}

; lecture des paramtres transmis
methode: system/options/cgi/request-method

either methode = "GET" [
    ; permet de rcuprer action et clescript pour les effacer
    ; clecateg est galement rcupr pour grer les retours
    data: system/options/cgi/query-string
] [
    data: copy ""
    len: to-integer system/options/cgi/content-length
    until [
        buffer: copy ""
        read-io system/ports/input buffer (to-integer system/options/cgi/content-length)
        append data buffer
        data: head data
        ((length? data) = len)
    ]
]
var: make object! decode-cgi data
action: to-integer var/action

db: open odbc://scripts
db/locals/auto-commit: false
update db
p: first db

if error? try [
    switch action [
        1 [
            ; cration d'une catgorie
            insert p [
                {INSERT INTO categories (categorie)
                VALUES(?) 
                } var/nom
            ]
        ]
        2 [
            ; mise  jour d'une catgorie
            insert p [
                {UPDATE categories
                SET categorie=?
                WHERE cle=?} 
                var/nom var/clecateg
            ]
        ]
        3 [
            ; effacement de la catgorie
            insert p [ "UPDATE scripts SET categorie=1 WHERE categorie=?" var/clecateg]
            insert p [ "DELETE FROM categories WHERE cle=?" var/clecateg ]  
        ]
    ]

    insert db [commit]
    print { 
    <CENTER>
    <H1>Opration termine</H1> 
    }
] [
    insert db [rollback]
    print {
    <CENTER>
    <H1>Echec de la mise  jour</H1>
    }
]

close p
close db

print join {<A href="editcateg.cgi?clecateg=0&clescript=} [
    var/clescript {">Retour</A>}
]
print "</CENTER></BODY></HTML>"